/*
 * Decompiled with CFR 0.152.
 */
package com.headfishindustries.milkspray.entities;

import com.headfishindustries.milkspray.MilkSpray;
import java.util.List;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySplashMilk
extends EntityThrowable {
    private boolean isLingering = false;

    public EntitySplashMilk(World w) {
        super(w);
    }

    public EntitySplashMilk(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySplashMilk(World worldIn, double x, double y, double z, boolean lingering) {
        this(worldIn, x, y, z);
        this.isLingering = lingering;
    }

    public EntitySplashMilk(World worldIn, EntityPlayer playerIn) {
        super(worldIn, (EntityLivingBase)playerIn);
    }

    public EntitySplashMilk(World worldIn, EntityPlayer playerIn, boolean lingering) {
        this(worldIn, playerIn);
        this.isLingering = lingering;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = true;
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && flag) {
                BlockPos blockpos = result.func_178782_a().func_177972_a(result.field_178784_b);
                this.extinguishFires(blockpos, result.field_178784_b);
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.extinguishFires(blockpos.func_177972_a(enumfacing), enumfacing);
                }
            }
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud();
            } else {
                this.applySplash(result);
            }
            int i = 2007;
            this.field_70170_p.func_175718_b(i, new BlockPos((Entity)this), 0xFFFFFF);
            this.func_70106_y();
        }
    }

    private void applySplash(RayTraceResult p_190543_1_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d0;
                if (!entitylivingbase.func_184603_cC() || !((d0 = this.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (entitylivingbase == p_190543_1_.field_72308_g) {
                    d1 = 1.0;
                }
                entitylivingbase.func_70674_bp();
            }
        }
    }

    private void makeAreaOfEffectCloud() {
        EntityMilkCloud entityareaeffectcloud = new EntityMilkCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityareaeffectcloud.func_184481_a(this.func_85052_h());
        entityareaeffectcloud.func_184483_a(3.0f);
        entityareaeffectcloud.func_184495_b(-0.5f);
        entityareaeffectcloud.func_184485_d(10);
        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
        entityareaeffectcloud.func_184482_a(0xFFFFFF);
        this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
    }

    private boolean isLingering() {
        return this.isLingering;
    }

    private void extinguishFires(BlockPos pos, EnumFacing p_184542_2_) {
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
            this.field_70170_p.func_175719_a((EntityPlayer)null, pos.func_177972_a(p_184542_2_), p_184542_2_.func_176734_d());
        }
    }

    public static void registerFixesPotion(DataFixer fixer) {
        EntityThrowable.func_189661_a((DataFixer)fixer, (String)"ThrownPotion");
        fixer.func_188258_a(FixTypes.ENTITY, (IDataWalker)new ItemStackData(EntityPotion.class, new String[]{"Potion"}));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isLingering = compound.func_74767_n("LINGERING");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("LINGERING", this.isLingering());
    }

    public static class RenderMilkSplash
    extends RenderSnowball<EntitySplashMilk> {
        public RenderMilkSplash(RenderManager renderManagerIn, RenderItem itemRendererIn) {
            super(renderManagerIn, (Item)MilkSpray.items.milk_bottle, itemRendererIn);
        }
    }

    public static class EntityMilkCloud
    extends EntityAreaEffectCloud {
        public EntityMilkCloud(World worldIn, double x, double y, double z) {
            super(worldIn, x, y, z);
        }

        public void func_70071_h_() {
            block12: {
                List list;
                float f;
                block10: {
                    int[] aint;
                    EnumParticleTypes enumparticletypes;
                    block11: {
                        super.func_70071_h_();
                        boolean flag = this.func_184497_n();
                        f = this.func_184490_j();
                        if (!this.field_70170_p.field_72995_K) break block10;
                        enumparticletypes = this.func_184493_l();
                        aint = new int[enumparticletypes.func_179345_d()];
                        if (aint.length > 0) {
                            aint[0] = this.func_189733_n();
                        }
                        if (aint.length > 1) {
                            aint[1] = this.func_189735_o();
                        }
                        if (!flag) break block11;
                        if (!this.field_70146_Z.nextBoolean()) break block12;
                        for (int i = 0; i < 2; ++i) {
                            float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                            float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                            float f3 = MathHelper.func_76134_b((float)f1) * f2;
                            float f4 = MathHelper.func_76126_a((float)f1) * f2;
                            if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                                int j = this.field_70146_Z.nextBoolean() ? 0xFFFFFF : this.func_184492_k();
                                int k = j >> 16 & 0xFF;
                                int l = j >> 8 & 0xFF;
                                int i1 = j & 0xFF;
                                this.field_70170_p.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, (double)((float)k / 255.0f), (double)((float)l / 255.0f), (double)((float)i1 / 255.0f), new int[0]);
                                continue;
                            }
                            this.field_70170_p.func_190523_a(enumparticletypes.func_179348_c(), this.field_70165_t + (double)f3, this.field_70163_u, this.field_70161_v + (double)f4, 0.0, 0.0, 0.0, aint);
                        }
                        break block12;
                    }
                    float f5 = (float)Math.PI * f * f;
                    int k1 = 0;
                    while ((float)k1 < f5) {
                        float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                        float f8 = MathHelper.func_76134_b((float)f6) * f7;
                        float f9 = MathHelper.func_76126_a((float)f6) * f7;
                        if (enumparticletypes == EnumParticleTypes.SPELL_MOB) {
                            int l1 = this.func_184492_k();
                            int i2 = l1 >> 16 & 0xFF;
                            int j2 = l1 >> 8 & 0xFF;
                            int j1 = l1 & 0xFF;
                            this.field_70170_p.func_190523_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
                        } else {
                            this.field_70170_p.func_190523_a(enumparticletypes.func_179348_c(), this.field_70165_t + (double)f8, this.field_70163_u, this.field_70161_v + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, aint);
                        }
                        ++k1;
                    }
                    break block12;
                }
                if (this.field_70173_aa >= this.func_184489_o()) {
                    this.func_70106_y();
                    return;
                }
                if (this.field_70173_aa % 5 == 0 && !(list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ())).isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        double d1;
                        double d0;
                        double d2;
                        if (!entitylivingbase.func_184603_cC() || !((d2 = (d0 = entitylivingbase.field_70165_t - this.field_70165_t) * d0 + (d1 = entitylivingbase.field_70161_v - this.field_70161_v) * d1) <= (double)(f * f))) continue;
                        entitylivingbase.func_70674_bp();
                    }
                }
            }
        }
    }
}

